* Table  - new table 2.do;
*version 17
#d ;
set more off;
set linesize 180;
pause on ; 

local xyear=2014;

cap log close;
log using "${log}99a Tables - Table 2.log", replace;
use "${CE}/ce_cpc_comb_haall_v7.dta", clear;  //uses 3 income grp imputation, shelter sub.;
count;

foreach x in c_rinkind c_rwic c_rschlunch c_rliheap c_rhousesub {;
	gen pos_`x'=`x'>0;
	};
***************;
* Note: to match CE we should exclude from CPS 7 states FIPS 19,35,38,50,56,44,40 where there is no CE data.
* unfortunately our CPSP data does not include State so we cannot.  So the samples will differ.;
 
label var c_rinc_winkindnoadj "Income Before Tax with in-kind, no adj";
label var c_rinck "Net Income";
label var c_rexp_resource_noadjust "Gross Expenditure";
label var c_rexpk_noadj "Expenditure with in-kind no adj";
label var c_rexp "Expenditure no in-kind with adj";
label var c_rexpk "Net Expenditure";
label var c_noncash "Total In-kind";
label var c_rliheap "Energy Asst.";
label var c_unadjust_rinc_noinkind2 "Gross Income";
tab c_house_grp, gen(thousegrp);
label var thousegrp1 "Owners with Mortgage";
label var thousegrp2 "Owners without Mortgage";
label var thousegrp3 "Renters";
label var c_fam_size "Family Size";
label var c_nchild "Number of Children";
label var c_nadult "Number of Adults";
label var c_elderly "Presence of Elderly";

gen c_adjust_notax=c_radjustments - c_rtaxm2;
label var c_adjust_notax "Non-tax Adjustments";

* resources without transfers.  transfers have no missings;
gen c_rinck_xf=c_rinck - c_rsnap;
gen c_rinck_xfh = c_rinck_xf-c_rhousesub;
gen c_rinck_xfhl = c_rinck_xfh-c_rschlunch;
gen c_rinck_xfhlw = c_rinck_xfhl-c_rwic;
gen c_rinck_xfhlwe = c_rinck_xfhlw-c_rliheap;

gen c_princk_xf= c_rinck_xf < c_rspm_thres; 
gen c_princk_xfh = c_rinck_xfh < c_rspm_thres;
gen c_princk_xfhl = c_rinck_xfhl < c_rspm_thres;
gen c_princk_xfhlw = c_rinck_xfhlw < c_rspm_thres;
gen c_princk_xfhlwe = c_rinck_xfhlwe < c_rspm_thres;

gen c_rexpk_xf=c_rexpk - c_rsnap;
gen c_rexpk_xfh = c_rexpk_xf-c_rhousesub;
gen c_rexpk_xfhl = c_rexpk_xfh-c_rschlunch;
gen c_rexpk_xfhlw = c_rexpk_xfhl-c_rwic;
gen c_rexpk_xfhlwe = c_rexpk_xfhlw-c_rliheap;

gen c_prexpk_xf= c_rexpk_xf < c_rspm_thres; 
gen c_prexpk_xfh = c_rexpk_xfh < c_rspm_thres;
gen c_prexpk_xfhl = c_rexpk_xfhl < c_rspm_thres;
gen c_prexpk_xfhlw = c_rexpk_xfhlw < c_rspm_thres;
gen c_prexpk_xfhlwe = c_rexpk_xfhlwe < c_rspm_thres;

*******************;
* grossincome is after tax plus snap;
gen c_rinc_gross=.;
replace c_rinc_gross=c_rfinc_addfsm - c_rtaxm2 if c_rfinc_addfsm <. & c_rtaxm2<.;
gen c_poor_rinc_gross = c_rinc_gross < c_rspm_thres;

* compute 20th pctle;
gen pct20rinc=.;
gen pct20rexp=.;
_pctile c_rinc_gross [aweight=c_popwt] if inlist(year,2017,2018,2019), percentiles(20);
replace pct20rinc= c_rinc_gross <r(r1)  if inlist(year,2017,2018,2019);
_pctile ce_rexp_noadj [aweight=c_popwt] if asec==0 & inlist(year,2017,2018,2019), percentiles(20);
replace pct20rexp= ce_rexp_noadj<r(r1) if asec==0 & inlist(year,2017,2018,2019);


* demographic vars for CE;
label var fam_type "Family Type";
label var ref_race "Race of Ref Person";
label var hisp_ref "Hispanicity Ref Person";
qui tab c_educref, g(educt);
qui tab c_race, g(race);
gen c_chldpres=.;
replace c_chldpres= c_nchild>0 & c_nchild<.;
label var elderly "Elderly Ref Person";

gen child = c_chldpres==1;
label var child "Child Poverty Rate";
gen elder = elderly==1;
label var elder "Elderly Poverty Rate";

keep if inlist(year,2017,2018,2019);
gen N = 1;

label define marrige 0 "Unmarried" 1 "Married";
label values c_married marrige;

label define old 0 "Non-Elderly" 1 "Elderly";
label values elderly old;

label define xc_chldpres 0 "No Children in HH" 1 "Children Present";
label values c_chldpres xc_chldpres;


foreach byvar in c_house_grp c_married c_race c_educref c_chldpres elderly {;
	preserve;
		collapse (mean) c_poor_rinck c_poor_rinc_gross c_poor_rexpk c_poor_rexp_noknoadj [aweight=c_perpopwt] , by(`byvar' asec) ; 
		decode `byvar', gen(`byvar'2);
		drop `byvar';
		ren `byvar'2 catvar;
		gen var = "`byvar'";
		order asecsurvey var catvar ;
		save "$temp/99a Table 3 `byvar'.dta", replace;
	restore ;
};

preserve;
collapse (mean) c_poor_rinck c_poor_rinc_gross c_poor_rexpk c_poor_rexp_noknoadj  if c_chldpres==1 [aweight=c_chldweight], by(asec) ; 
gen var = "child_poverty";
gen catvar = var;
foreach byvar in child_poverty {;
	save  "$temp/99a Table 3 `byvar'.dta", replace;
};

restore,preserve;
collapse (mean) c_poor_rinck c_poor_rinc_gross c_poor_rexpk c_poor_rexp_noknoadj  if elderly==1 [aweight=c_ot64weight], by(asec) ; 
gen var = "elderly_poverty";
gen catvar = var;
foreach byvar in elderly_poverty {;
	save  "$temp/99a Table 3 `byvar'.dta", replace;
};

restore, preserve;
collapse (mean) c_poor_rinck c_poor_rinc_gross c_poor_rexpk c_poor_rexp_noknoadj (sum) N [aweight=c_perpopwt], by(asec) ; 
gen var = "poverty_rate";
gen catvar = var;
foreach byvar in c_house_grp c_married c_race c_educref child_poverty elderly_poverty {;
	append using "$temp/99a Table 3 `byvar'.dta";
};


levelsof N if asecsurvey == 0, local(nval);
replace N = `nval' if asecsurvey == 0;
levelsof N if asecsurvey == 1, local(nval);
replace N = `nval' if asecsurvey == 1;


gen _mi_miss=0;
gen _mi_id=0;
mi extract 0, clear;
reshape wide c_poor_rinck c_poor_rinc_gross c_poor_rexpk c_poor_rexp_noknoadj N, i(var catvar) j(asecsurvey) ; 

* Limit fields;
drop c_poor_rinck0 c_poor_rinc_gross0 c_poor_rexpk1 c_poor_rexp_noknoadj1 var; 
order catvar c_poor_rexp_noknoadj0 c_poor_rexpk0 N0 c_poor_rinc_gross1 c_poor_rinck1 N1;

keep if !mi(catvar);
gen t_sort = . ;
replace t_sort = 1 if catvar == "Owner w/ Mortgage";
replace t_sort = 2 if catvar == "Owner w/o Mortgage";
replace t_sort = 3 if catvar == "Renter";
replace t_sort = 4 if catvar == "Unmarried";
replace t_sort = 5 if catvar == "Married";
replace t_sort = 6 if catvar == "elderly_poverty";
replace t_sort = 8 if catvar == "child_poverty";
replace t_sort = 10  if catvar == "White NH";
replace t_sort = 11  if catvar == "Black NH";
replace t_sort = 12 if catvar == "Hispanic (any race)";
replace t_sort = 13 if catvar == "Other race, NH";
replace t_sort = 14 if catvar == "<HS";
replace t_sort = 15 if catvar == "HS";
replace t_sort = 16 if catvar == "Assoc, BA, or more";
replace t_sort = 17 if catvar == "poverty_rate";
sort t_sort;
drop t_sort;

replace catvar = "White" if catvar == "White NH";
replace catvar = "Black" if catvar == "Black NH";
replace catvar = "Hispanic" if catvar == "Hispanic (any race)";
replace catvar = "Other Race" if catvar == "Other race, NH";
replace catvar = "< High School" if catvar == "<HS";
replace catvar = "High School" if catvar == "HS";
replace catvar = "AS, BA, or More" if catvar == "Assoc, BA, or more";
replace catvar = "Poverty Rate" if catvar == "poverty_rate";
replace catvar = "Child Poverty Rate" if catvar== "child_poverty";
replace catvar = "Elderly Poverty Rate" if catvar== "elderly_poverty";

expand 2 if _n == _N ; 
replace c_poor_rexpk0 = N0 if _n == _N;
replace c_poor_rinck1 = N1 if _n == _N;
for var c_poor_rexp_noknoadj0 c_poor_rinc_gross1 : replace X = . if _n == _N ;
replace catvar = "Sample Size" if _n == _N ;
drop N0 N1 ; 

label var catvar " " ;
label var c_poor_rexp_noknoadj0 "SEPM Gross" ;
label var c_poor_rexpk0 "SEPM Net" ;
label var c_poor_rinc_gross1 "SIPM Gross" ;
label var c_poor_rinck1 "SIPM Net" ;

export excel using "${outgraph}99 Tables.xlsx", sheet("r.Table 2") sheetreplace firstrow(varlabel) ; 

log close; 
